const User = require('../models/userModel');

class NotificationHelper {
  static async sendMessageNotification(wss, clients, recipientId, senderId, messageId, type) {
    try {
      // Get sender details
      const sender = await User.findById(senderId);
      if (!sender) {
        console.error('Sender not found');
        return;
      }

      const notification = {
        type: type, // 'message' or 'reply'
        messageId: messageId,
        user: {
          id: sender.id,
          first_name: sender.first_name,
          last_name: sender.last_name,
          profile_url: sender.profile_url || null
        },
        timestamp: new Date().toISOString()
      };

      // Check if recipient is connected
      const client = clients.get(recipientId.toString());
      if (client && client.readyState === 1) { // 1 = OPEN
        client.send(JSON.stringify(notification));
        console.log(`Notification sent to user ${recipientId}`);
      } else {
        console.log(`User ${recipientId} is not connected to WebSocket`);
      }
    } catch (error) {
      console.error('Error sending notification:', error);
    }
  }
}

module.exports = NotificationHelper;