const express = require('express');
const router = express.Router();
const { authenticate } = require('../middleware/authMiddleware');
const userController = require('../controllers/userController');
const { upload, resizeProfilePic } = require('../middleware/profileUpload');



router.get('/users/all',authenticate, userController.getCategorizedUsers);

router.get('/users/deskOfficers',authenticate, userController.getDeskOfficers);
router.post('/users/deskOfficers/create',authenticate, userController.addDeskOfficer);
router.post('/users/deskOfficers/edit',authenticate, userController.editDeskOfficer);
router.post('/users/deskOfficers/delete',authenticate, userController.removeDeskOfficer);



router.get('/users/members',authenticate, userController.getMembers);
router.post('/users/members/create',authenticate, userController.addMember);
router.post('/users/members/edit',authenticate, userController.editMember);
router.post('/users/members/delete',authenticate, userController.removeMember);

// Partner routes
router.get('/users/partners', authenticate, userController.getPartners);
router.post('/users/partners/create', userController.createPartner);
router.post('/users/partners/approve', authenticate, userController.approvePartner);
router.post('/users/partners/decline', authenticate, userController.declinePartner);  


// Add to userRoutes.js
router.post('/users/send-otp', userController.sendOTP);
router.post('/users/verify-otp', userController.verifyOTP);
router.post('/users/change-password', userController.changePassword);

router.post('/users/upload-profile', authenticate, upload.single('profile'), resizeProfilePic, userController.uploadProfile);

module.exports = router;