const express = require('express');
const router = express.Router();
const { authenticate } = require('../middleware/authMiddleware');
const postController = require('../controllers/postController');
const upload = require('../middleware/uploadMiddleware'); // Import the upload middleware

// Posts Routes
router.get('/posts',authenticate, postController.getPosts);
router.get('/approved-posts',postController.getApprovedPosts);
router.get('/posts/get-my-posts',authenticate, postController.getMyPosts);
router.post('/posts/user', postController.getPostsForUser);
router.post('/posts/react', authenticate, postController.reactToPost);
router.post('/posts/delete/reaction', authenticate, postController.removeReaction);
router.post('/posts/approve', postController.approvePost);

// Create post with file upload
router.post(
  '/posts/create',
  authenticate,
  upload.array('attachments', 5), // Use the upload middleware here
  postController.createPost
);

router.delete('/posts/:id', authenticate, postController.deletePost);

module.exports = router;