const express = require('express');
const router = express.Router();
const { authenticate } = require('../middleware/authMiddleware');
const paymentsController = require('../controllers/paymentsController');


router.get('/donations', authenticate, paymentsController.getAllDonations);
router.get('/my-donations', authenticate, paymentsController.getMyDonations);
router.post('/donations', authenticate, paymentsController.createDonation);
router.post('/:transaction_id/status', authenticate, paymentsController.updatePaymentStatus);
router.post('/paychangu-webhook', paymentsController.paychanguWebhook);


module.exports = router;