const express = require('express');
const router = express.Router();
const { authenticate } = require('../middleware/authMiddleware');
const messageController = require('../controllers/messageController');
const upload = require('../middleware/MessageUploadMiddleware');

// Get all messages for the authenticated user
router.get('/messages/', authenticate, messageController.getAllMessages);


// Get all messages for the authenticated user
router.get('/unread-messages-count', authenticate, messageController.getUnreadCount);

// Get a specific message
router.get('/messages/:id', authenticate, messageController.getMessageById);

// Delete a message (from recipient's view)
router.delete('/messages/:id', authenticate, messageController.deleteMessage);

// Create a new message with attachments
router.post(
  '/messages/',
  authenticate,
  upload.array('attachments', 5),
  messageController.createMessage
);

// Add a reply to a message with attachments
router.post(
  '/messages/:id/reply',
  authenticate,
  upload.array('attachments', 5),
  messageController.addReply
);

module.exports = router;