const express = require('express');
const router = express.Router();
const { authenticate } = require('../middleware/authMiddleware');
const cellGroupController = require('../controllers/cellGroupController');

// Cell Group Routes
router.get('/cell-groups', cellGroupController.getAllCellGroups);
router.post('/cell-groups/get', cellGroupController.getCellGroupById);
router.post('/cell-groups/create', authenticate, cellGroupController.createCellGroup);
router.post('/cell-groups/update', authenticate, cellGroupController.updateCellGroup);
router.post('/cell-groups/delete', authenticate, cellGroupController.deleteCellGroup);
router.post('/cell-groups/assign-leader', authenticate, cellGroupController.assignLeader);
router.post('/cell-groups/by-leader', cellGroupController.getCellGroupsByLeader);

module.exports = router;