const pool = require('../config/db');

class RefreshToken {
    static async create({ user_id, token, expires_at }) {
        const [result] = await pool.query(
            'INSERT INTO refresh_tokens (user_id, token, expires_at) VALUES (?, ?, ?)',
            [user_id, token, expires_at]
        );
        return result.insertId;
    }

    static async findByToken(token) {
        const [rows] = await pool.query('SELECT * FROM refresh_tokens WHERE token = ?', [token]);
        return rows[0];
    }

    static async deleteByToken(token) {
        await pool.query('DELETE FROM refresh_tokens WHERE token = ?', [token]);
    }

    static async deleteExpiredTokens() {
        await pool.query('DELETE FROM refresh_tokens WHERE expires_at < NOW()');
    }
}

module.exports = RefreshToken;