const pool = require('../config/db');

class Post {
   static async create(userId, post, is_approved = false, approved_by = null) {
  

  try {
    const sql = `
      INSERT INTO posts 
      (user_id, post, is_approved, approved_by) 
      VALUES (?, ?, ?, ?)
    `;
    const params = [userId, post, is_approved, approved_by];


    const [result] = await pool.query(sql, params);
    return result.insertId;
  } catch (error) {
    throw error;
  }
}

    static async getById(id) {
        const [rows] = await pool.query('SELECT * FROM posts WHERE id = ?', [id]);
        return rows[0];
    }

    static async getAll() {
        const [rows] = await pool.query('SELECT * FROM posts ORDER BY created_at DESC');
        return rows;
    }

    static async getApprovedPosts() {
        const [rows] = await pool.query('SELECT * FROM posts WHERE is_approved = TRUE ORDER BY created_at DESC');
        return rows;
    }

    static async getAllForUser(userId) {
        const [rows] = await pool.query(
            'SELECT * FROM posts WHERE user_id = ? AND is_approved = TRUE ORDER BY created_at DESC',
            [userId]
        );
        return rows;
    }

    static async getApprovedPosts() {
        const [rows] = await pool.query('SELECT * FROM posts WHERE is_approved = TRUE ORDER BY created_at DESC');
        return rows;
    }

    static async getMyPosts(userId) {
        const [rows] = await pool.query(
            'SELECT * FROM posts WHERE user_id = ? ORDER BY created_at DESC',
            [userId]
        );
        return rows;
    }

    static async approvePost(postId, userId, isApproved) {
    try {
        const sql = `
            UPDATE posts 
            SET is_approved = ?, 
                approved_by = ?
            WHERE id = ?
        `;
        // Use isApproved as 0 or 1, and set approved_by only when approving (1)
        const params = [isApproved, isApproved == 1 ? userId : null, postId];
        
        const [result] = await pool.query(sql, params);
        return result.affectedRows > 0;
    } catch (error) {
        throw error;
    }
}

static async getApprovalStatus(postId) {
    try {
        const [rows] = await pool.query(
            'SELECT is_approved, approved_by FROM posts WHERE id = ?', 
            [postId]
        );
        return rows[0] || null;
    } catch (error) {
        throw error;
    }
}static async approvePost(postId, userId, isApproved) {
    try {
        const sql = `
            UPDATE posts 
            SET is_approved = ?, 
                approved_by = ?
            WHERE id = ?
        `;
        // Use isApproved as 0 or 1, and set approved_by only when approving (1)
        const params = [isApproved, isApproved == 1 ? userId : null, postId];
        
        const [result] = await pool.query(sql, params);
        return result.affectedRows > 0;
    } catch (error) {
        throw error;
    }
}

static async getApprovalStatus(postId) {
    try {
        const [rows] = await pool.query(
            'SELECT is_approved, approved_by FROM posts WHERE id = ?', 
            [postId]
        );
        return rows[0] || null;
    } catch (error) {
        throw error;
    }
}

   // Add these methods to your Post class
static async delete(id) {
    const [result] = await pool.query('DELETE FROM posts WHERE id = ?', [id]);
    return result;
}

static async isOwner(postId, userId) {
    const [rows] = await pool.query(
        'SELECT id FROM posts WHERE id = ? AND user_id = ?',
        [postId, userId]
    );
    return rows.length > 0;
}

}

module.exports = Post;