const pool = require('../config/db');

class PostAttachment {
    static async getByPostId(postId) {
        const [rows] = await pool.query('SELECT * FROM post_attachments WHERE post_id = ?', [postId]);
        return rows;
    }

    static async getAll() {
        const [rows] = await pool.query('SELECT * FROM post_attachments');
        return rows;
    }
      static async create(postId, attachmentData) {
    const [result] = await pool.query(
      'INSERT INTO post_attachments (post_id, attachment_type, attachment_url) VALUES (?, ?, ?)',
      [postId, attachmentData.type, attachmentData.url]
    );
    return result;
  }
}

module.exports = PostAttachment;