const General = require('../models/generalModel');

const GeneralController = {
    getSummaryStats: async (req, res, next) => {
        try {
            const stats = await General.getSummaryStats();
            
            res.status(200).json({
                success: true,
                statusCode: 200,
                message: "Summary statistics retrieved successfully",
                data: {
                    total_users: stats.total_users,
                    total_samaritan_partners: stats.total_samaritan_partners,
                    total_posts: stats.total_posts,
                    pending_approval_posts: stats.pending_approval_posts,
                    total_messages_sent: stats.total_messages_sent,
                    total_cell_groups: stats.total_cell_groups,
                    total_donations: stats.total_donations,
                    total_donation_amount: stats.total_donation_amount
                }
            });
        } catch (error) {
            next(error);
        }
    },
    getAuditTrails: async (req, res, next) => {
        try {
            const auditTrails = await General.getAuditTrails();
            
            res.status(200).json({
                success: true,
                statusCode: 200,
                message: "auditTrails retrieved successfully",
                data: auditTrails
            });
        } catch (error) {
            next(error);
        }
    }
};

module.exports = GeneralController;